/*
 * Software is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 *
 * The Initial Developer of a code related to English / Russian transformation is SoftCorporation LLC.
 * Usage of this code allowed only with reference to SoftCorporation LLC.
 * which means including on a page which uses this code (or modified code) 
 * the visible and clickable link to: http://www.softcorporation.com/products/cyrillic
 * Copyright (C) 2000-2006 SoftCorporation LLC. All Rights Reserved.
 */
var SE  = "`qwertyuiop[]\\asdfghjkl;'zxcvbnm,./~@#$^&QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?";
var SR1 = new Array(
1102,1103,1078,1077,1088,1090,1099,1091,1080,1086,1087,1096,1097,1101,1072,1089,1076,1092,1075,1093,1081,1082,1083,1095,1105,1079,1100,1094,1074,1073,1085,1084,44,46,1098,1070,34,8470,63,92,47,1071,1046,1045,1056,1058,1067,1059,1048,1054,1055,1064,1065,1069,1040,1057,1044,1060,1043,1061,1049,1050,1051,1063,1025,1047,1068,1062,1042,1041,1053,1052,59,58,1066);
var SR2 = new Array(
96,1081,1094,1091,1082,1077,1085,1075,1096,1097,1079,1093,1098,92,1092,1099,1074,1072,1087,1088,1086,1083,1076,1078,1101,1103,1095,1089,1084,1080,1090,1100,1073,1102,46,126,8470,63,47,94,38,1049,1062,1059,1050,1045,1053,1043,1064,1065,1047,1061,1066,92,1060,1067,1042,1040,1055,1056,1054,1051,1044,1046,1069,1071,1063,1057,1052,1048,1058,1068,1041,1070,44);
var lang = 'ru';
var layout = '1';
var capsLock = false;
var shift = false;
var brid = "";
var hideTime = true;
var emailText= "";

if (parseInt(navigator.appVersion)>=3)
{
  if (navigator.appName.indexOf("Microsoft")!=-1) brid = "IE"
  else if (navigator.appName.indexOf("Mac")!=-1) brid = "MAC"
  else if (navigator.appName.indexOf("Netscape")!=-1) brid = "NC";
}
if (brid != "IE")
{
	alert("Attention! This version works only with Microsoft Internet Explorer.");
}

function getkey(evt)
{
  if (window.event) return window.event.keyCode
  else return (evt.which || evt.charCode || evt.keyCode);
}

function setkey(e, s)
{
  if (window.event) window.event.keyCode = s
  else if (e) e.which = s;
}

function processKey(form, e)
{
  if (getkey(e) == 123) // F12
  {
	chgLang(form);
  }
  if (getkey(e) == 118) // F7
  {
    spellCheckStart(form.text);
  }
}

function translate(field, evt)
{
  var key = getkey(evt);
  if (lang == 'ru')
  {
    setkey(evt, trans(key));
  }
  return false;
}

function trans(key)
{
  if (lang == 'ru')
  {
    var i = SE.indexOf(String.fromCharCode(key));
    if (i >= 0)
    {
      if (layout == '1')
      {
        key = SR1[i];
      }
      else if (layout == '2')
      {
        key = SR2[i];
      }
    }
  }
  return key;
}

function swapImage(name, image)
{
  if (window.document.images) window.document.images[name].src = image;
}

function chgLayout(form, l)
{
  layout = l.value;
  l.checked = true;
  form.text.focus();
  if (layout == '1') swapImage('imgLayout','lay1.gif')
  else if (layout == '2') swapImage('imgLayout','lay2.gif')
}

function chgLang(form)
{
  if (lang == 'en')
  {
    lang = 'ru';
    form.lang.value = "  Russian ";
  }
  else
  {
    lang = 'en';
    form.lang.value = "  English  ";
  }
  form.text.focus();
}

function pressBtn(chr)
{
  var c = chr;
  if ( chr == 'bs') { backAtCursor(window.document.cyr.text); }
  else if ( chr == 'caps') { capsLock = !capsLock; }
  else if ( chr == 'shift-l' || chr == 'shift-r') { shift = true; }
  else if ( chr == 'ctrl-l' || chr == 'ctrl-r') { }
  else if ( chr == 'alt-l' || chr == 'alt-r') { }
  else
  {
    if ( chr == 'space' ) { c = ' '; }
    else if ( chr == 'enter' ) { c = '\n'; }
    else if ( chr == 'tab' ) { c = '\t'; }
    else 
	{
	  if (capsLock)
      {
        if (shift)
	    {
		  shift = false;
		}
		else
		{
          c = getUpCase(chr);
	    }
      }
	  if (shift)
	  {
        c = getUpCase(chr);
	    shift = false;
	  }
      c = String.fromCharCode(trans(c.charCodeAt(0)));
    }
    insertAtCursor(window.document.cyr.text, c);
  }
  window.document.cyr.text.focus();
}

function insertAtCursor(fld, val)
{
  fld.focus();
  //IE support
  if (document.selection)
  {
    var sel = document.selection.createRange();
    sel.text = val;
  }
  //MOZILLA/NETSCAPE support
  else if (fld.selectionStart || fld.selectionStart == '0') 
  {
    var startPos = fld.selectionStart;
    var endPos = fld.selectionEnd;
    fld.value = fld.value.substring(0, startPos) + val + fld.value.substring(endPos, fld.value.length);
  }
  else
  {
    fld.value += val;
  }
//  fld.focus();
}

function backAtCursor(fld)
{
  fld.focus();
  if (document.selection)
  {
    sel = document.selection.createRange();
    if(sel.text.length > 0)
    {
      sel.text='';
    }
	else
	{
      sel.moveStart('character',-1);
      sel.text='';
    }
    sel.select();
  }
  else if (fld.selectionStart || fld.selectionStart == '0') 
  {
	//MOZILLA/NETSCAPE support
    var startPos = fld.selectionStart;
    var endPos = fld.selectionEnd;
    fld.value = fld.value.substring(0, startPos-1) + fld.value.substring(endPos, fld.value.length);
    fld.selectionStart = startPos-1;
    fld.selectionEnd = startPos-1;
  }
  else
  {
    fld.value=fld.value.substr(0,(fld.value.length-1));
  }
//  fld.focus();
}

function getUpCase(chr)
{
  var out = chr;
  switch (chr) 
  {
    case "`" : out="~"; break;
    case "1" : out="!"; break;
    case "2" : out="@"; break;
    case "3" : out="#"; break;
    case "4" : out="$"; break;
    case "5" : out="%"; break;
    case "6" : out="^"; break;
    case "7" : out="&"; break;
    case "8" : out="*"; break;
    case "9" : out="("; break;
    case "0" : out=")"; break;
    case "-" : out="_"; break;
    case "=" : out="+"; break;
    case ";" : out=":"; break;
    case "[" : out="{"; break;
    case "]" : out="}"; break;
    case "," : out="<"; break;
    case "." : out=">"; break;
    case "'" : out='"'; break;
    case "/" : out="?"; break;
    case "\\" : out="|"; break;	
    default :  out = chr.toUpperCase();
  }
  return out;
}

function copyText(field)
{
  window.clipboardData.setData('Text', field.innerText);
}

function clearAll(field)
{
  if (window.confirm('WARNING: All editor data will be lost!'))
  {
    field.value='';
  }
  field.focus();
}

function submitSearch(url)
{
  var text = trim(clean(window.document.cyr.text.innerText));
  if (text.length == 0)
  {
    alert('Please enter text to search.');
	window.document.cyr.text.focus();
    return;
  }
  if (text.length > 50)
  {
    if (!window.confirm('WARNING: Do you really wish to send all text to the search engine?'))
    {
	  return;
    }
  }
  window.open(url + buildURL(text));
}

function trim(string)
{
  var trim_pattern=/^\s*|\s*$/g;
  return string.replace(trim_pattern,"");
}

function clean(string)
{
  var clean_pattern=/\s+/g;
  return string.replace(clean_pattern," ");
}

//UTF-8 Support
function buildURL(fld)
{
	if (fld == "") return '';
	var encodedField = "";
	var s = fld;
	if (typeof encodeURIComponent == "function")
	{
		// Use JavaScript built-in function
		// IE 5.5+ and Netscape 6+ and Mozilla
		encodedField = encodeURIComponent(s);
	}
	else 
	{   
		// Need to mimic the JavaScript version
		// Netscape 4 and IE 4 and IE 5.0
		encodedField = encodeURIComponentNew(s);
	}	
	return encodedField;
}

function utf8(wide) 
{
  var c, s;
  var enc = "";
  var i = 0;
  while(i<wide.length) 
  {
    c= wide.charCodeAt(i++);
    // handle UTF-16 surrogates
    if (c>=0xDC00 && c<0xE000) continue;
    if (c>=0xD800 && c<0xDC00) 
	{
      if (i>=wide.length) continue;
      s= wide.charCodeAt(i++);
      if (s<0xDC00 || c>=0xDE00) continue;
      c= ((c-0xD800)<<10)+(s-0xDC00)+0x10000;
    }
    // output value
    if (c<0x80) enc += String.fromCharCode(c);
    else if (c<0x800) enc += String.fromCharCode(0xC0+(c>>6),0x80+(c&0x3F));
    else if (c<0x10000) enc += String.fromCharCode(0xE0+(c>>12),0x80+(c>>6&0x3F),0x80+(c&0x3F));
    else enc += String.fromCharCode(0xF0+(c>>18),0x80+(c>>12&0x3F),0x80+(c>>6&0x3F),0x80+(c&0x3F));
  }
  return enc;
}

var hexchars = "0123456789ABCDEF";
function toHex(n) 
{
  return hexchars.charAt(n>>4)+hexchars.charAt(n & 0xF);
}

var okURIchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";
function encodeURIComponentNew(s) 
{
  var s = utf8(s);
  var c;
  var enc = "";
  for (var i= 0; i<s.length; i++) 
  {
    if (okURIchars.indexOf(s.charAt(i))==-1) enc += "%"+toHex(s.charCodeAt(i));
    else enc += s.charAt(i);
  }
  return enc;
}

function sendMail(field) 
{
  mailText = field.value;
  var text = trim(clean(mailText));
  if (text.length == 0)
  {
    alert('Please enter text to send.');
	field.focus();
    return;
  }
  var popupwindow=window.open('emailPopup.html','emailwin','left=20,top=20,width=500,height=350,toolbar=0,resizable=0');
}
